// RTScrollBar1.cpp : ʵļ
//

#include "stdafx.h"
#include "RTScrollBar1.h"
#include "RTDraw.h"

// CRTScrollBar1

IMPLEMENT_DYNAMIC(CRTScrollBar1, CScrollBar)
CRTScrollBar1::CRTScrollBar1()
{
	m_bMouseDown = FALSE;
	m_bMouseDownArrowForback = FALSE;
	m_bMouseDownArrowForwad = FALSE;
	m_bDragging = FALSE;
	m_nThumbStart = 0;
}

CRTScrollBar1::~CRTScrollBar1()
{
}

CBitmap* CRTScrollBar1::m_ScrollBarUpArrowBitmap[5] = {NULL,NULL,NULL,NULL,NULL};
CBitmap* CRTScrollBar1::m_ScrollBarLeftArrowBitmap[5] = {NULL,NULL,NULL,NULL,NULL};
CBitmap* CRTScrollBar1::m_ScrollBarDownArrowBitmap[5] = {NULL,NULL,NULL,NULL,NULL};
CBitmap* CRTScrollBar1::m_ScrollBarRightArrowBitmap[5] = {NULL,NULL,NULL,NULL,NULL};

UINT     CRTScrollBar1::m_ScrollBarUpArrowBitmapDrawMode[5] = {0,0,0,0,0};
UINT     CRTScrollBar1::m_ScrollBarLeftArrowBitmapDrawMode[5] = {0,0,0,0,0};
UINT     CRTScrollBar1::m_ScrollBarDownArrowBitmapDrawMode[5] = {0,0,0,0,0};
UINT     CRTScrollBar1::m_ScrollBarRightArrowBitmapDrawMode[5] = {0,0,0,0,0};

CBitmap* CRTScrollBar1::m_ScrollBarHorizontalBitmap[5] = {NULL,NULL,NULL,NULL,NULL};
CBitmap* CRTScrollBar1::m_ScrollBarVerticalBitmap[5] = {NULL,NULL,NULL,NULL,NULL};
UINT     CRTScrollBar1::m_ScrollBarHorizontalBitmapDrawMode[5] = {0,0,0,0,0};
UINT     CRTScrollBar1::m_ScrollBarVerticalBitmapDrawMode[5] = {0,0,0,0,0};
BOOL     CRTScrollBar1::m_IsEnableRTStyle = TRUE;

BEGIN_MESSAGE_MAP(CRTScrollBar1, CScrollBar)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_MOUSEWHEEL()
	ON_WM_PAINT()
END_MESSAGE_MAP()



// CRTScrollBar1 Ϣ
void CRTScrollBar1::DrawVertical(CDC* pDC)
{
	CRect clientRect;
	GetClientRect(&clientRect);
	CMemDC memDC(pDC, &clientRect);
	
	BOOL IsWindowEnable = IsWindowEnabled();
	//draw up arrow of scrollbar
	CRect rtUpArrow(clientRect.left,clientRect.top,clientRect.right,clientRect.top + clientRect.Width());
	
	if(m_SizeArea == AreaTop)
	{
		CRTDraw::RTDrawBitmap(&memDC,&rtUpArrow,m_ScrollBarVerticalBitmap[BMP_BACK],m_ScrollBarVerticalBitmapDrawMode[BMP_BACK]);
		rtUpArrow.OffsetRect(0,clientRect.Width());
	}
	if(!IsWindowEnable)
		CRTDraw::RTDrawBitmap(&memDC,&rtUpArrow,m_ScrollBarUpArrowBitmap[BMP_DISABLE],m_ScrollBarUpArrowBitmapDrawMode[BMP_DISABLE]);
	else
	{
		if(m_bMouseDownArrowForback)
			CRTDraw::RTDrawBitmap(&memDC,&rtUpArrow,m_ScrollBarUpArrowBitmap[BMP_DOWN],m_ScrollBarUpArrowBitmapDrawMode[BMP_DOWN]);
		else
			CRTDraw::RTDrawBitmap(&memDC,&rtUpArrow,m_ScrollBarUpArrowBitmap[BMP_NORMAL],m_ScrollBarUpArrowBitmapDrawMode[BMP_NORMAL]);
	}
	
	//draw right arrow
	CRect rtDownArrow(clientRect.left,clientRect.bottom - clientRect.Width(),clientRect.right,clientRect.bottom);
	
	if(m_SizeArea == AreaBottom)
	{
		CRTDraw::RTDrawBitmap(&memDC,&rtDownArrow,m_ScrollBarVerticalBitmap[BMP_BACK],m_ScrollBarVerticalBitmapDrawMode[BMP_BACK]);
		rtUpArrow.OffsetRect(0,0-clientRect.Width());
	}
	if(!IsWindowEnable)
		CRTDraw::RTDrawBitmap(&memDC,&rtDownArrow,m_ScrollBarDownArrowBitmap[BMP_DISABLE],m_ScrollBarDownArrowBitmapDrawMode[BMP_DISABLE]);
	else
	{
		if(m_bMouseDownArrowForwad)
			CRTDraw::RTDrawBitmap(&memDC,&rtDownArrow,m_ScrollBarDownArrowBitmap[BMP_DOWN],m_ScrollBarDownArrowBitmapDrawMode[BMP_DOWN]);
		else
			CRTDraw::RTDrawBitmap(&memDC,&rtDownArrow,m_ScrollBarDownArrowBitmap[BMP_NORMAL],m_ScrollBarDownArrowBitmapDrawMode[BMP_NORMAL]);
	}
	
	//draw back
	CRect rtBack(clientRect.left,rtUpArrow.bottom,clientRect.right,rtDownArrow.top);
	CRTDraw::RTDrawBitmap(&memDC,&rtBack,m_ScrollBarVerticalBitmap[BMP_BACK],m_ScrollBarVerticalBitmapDrawMode[BMP_BACK]);

	CRect rtThumb;
	rtThumb.left = clientRect.left + m_nThumbStart;
	rtThumb.top = rtUpArrow.bottom + m_nThumbStart;
	rtThumb.right = clientRect.right;
	rtThumb.bottom = rtThumb.top + (rtDownArrow.top - rtUpArrow.bottom)/10;

	if(rtThumb.bottom == rtThumb.top)rtThumb.bottom = rtThumb.top + 3;

	if(!IsWindowEnable)
		CRTDraw::RTDrawBitmap(&memDC,&rtThumb,m_ScrollBarVerticalBitmap[BMP_DISABLE],m_ScrollBarVerticalBitmapDrawMode[BMP_DISABLE]);
	else
	{
		if(m_bDragging)
			CRTDraw::RTDrawBitmap(&memDC,&rtThumb,m_ScrollBarVerticalBitmap[BMP_DOWN],m_ScrollBarVerticalBitmapDrawMode[BMP_DOWN]);
		else
			CRTDraw::RTDrawBitmap(&memDC,&rtThumb,m_ScrollBarVerticalBitmap[BMP_NORMAL],m_ScrollBarVerticalBitmapDrawMode[BMP_NORMAL]);
	}
}

void CRTScrollBar1::DrawHorizontal(CDC *pDC)
{
	CRect clientRect;
	GetClientRect(&clientRect);
	CMemDC memDC(pDC, &clientRect);
	
	BOOL IsWindowEnable = IsWindowEnabled();
	//draw left arrow of scrollbar
	CRect rtLeftArrow(clientRect.left,clientRect.top,clientRect.left + clientRect.Height(),clientRect.bottom);
	
	if(m_SizeArea == AreaLeft)
	{
		CRTDraw::RTDrawBitmap(&memDC,&rtLeftArrow,m_ScrollBarHorizontalBitmap[BMP_BACK],m_ScrollBarHorizontalBitmapDrawMode[BMP_BACK]);
		rtLeftArrow.OffsetRect(clientRect.Height(),0);
	}
	if(!IsWindowEnable)
		CRTDraw::RTDrawBitmap(&memDC,&rtLeftArrow,m_ScrollBarLeftArrowBitmap[BMP_DISABLE],m_ScrollBarLeftArrowBitmapDrawMode[BMP_DISABLE]);
	else
	{
		if(m_bMouseDownArrowForback)
			CRTDraw::RTDrawBitmap(&memDC,&rtLeftArrow,m_ScrollBarLeftArrowBitmap[BMP_DOWN],m_ScrollBarLeftArrowBitmapDrawMode[BMP_DOWN]);
		else
			CRTDraw::RTDrawBitmap(&memDC,&rtLeftArrow,m_ScrollBarLeftArrowBitmap[BMP_NORMAL],m_ScrollBarLeftArrowBitmapDrawMode[BMP_NORMAL]);
	}
	
	//draw right arrow
	CRect rtRightArrow(clientRect.right - clientRect.Height(),clientRect.top,clientRect.right,clientRect.bottom);
	
	if(m_SizeArea == AreaRight)
	{
		CRTDraw::RTDrawBitmap(&memDC,&rtRightArrow,m_ScrollBarHorizontalBitmap[BMP_BACK],m_ScrollBarHorizontalBitmapDrawMode[BMP_BACK]);
		rtRightArrow.OffsetRect(0-clientRect.Height(),0);
	}
	if(!IsWindowEnable)
		CRTDraw::RTDrawBitmap(&memDC,&rtRightArrow,m_ScrollBarRightArrowBitmap[BMP_DISABLE],m_ScrollBarRightArrowBitmapDrawMode[BMP_DISABLE]);
	else
	{
		if(m_bMouseDownArrowForwad)
			CRTDraw::RTDrawBitmap(&memDC,&rtRightArrow,m_ScrollBarRightArrowBitmap[BMP_DOWN],m_ScrollBarRightArrowBitmapDrawMode[BMP_DOWN]);
		else
			CRTDraw::RTDrawBitmap(&memDC,&rtRightArrow,m_ScrollBarRightArrowBitmap[BMP_NORMAL],m_ScrollBarRightArrowBitmapDrawMode[BMP_NORMAL]);
	}
	
	//draw back
	CRect rtBack(rtLeftArrow.right,clientRect.top,rtRightArrow.left,clientRect.bottom);
	CRTDraw::RTDrawBitmap(&memDC,&rtBack,m_ScrollBarHorizontalBitmap[BMP_BACK],m_ScrollBarHorizontalBitmapDrawMode[BMP_BACK]);

	CRect rtThumb;
	rtThumb.left =  rtLeftArrow.right + m_nThumbStart;
	rtThumb.top = clientRect.top;
	rtThumb.right = rtThumb.left + (rtRightArrow.left - rtLeftArrow.right) / 10;
	rtThumb.bottom = clientRect.bottom;

	if(rtThumb.right == rtThumb.left)rtThumb.right = rtThumb.left + 3;

	if(!IsWindowEnable)
		CRTDraw::RTDrawBitmap(&memDC,&rtThumb,m_ScrollBarHorizontalBitmap[BMP_DISABLE],m_ScrollBarHorizontalBitmapDrawMode[BMP_DISABLE]);
	else
	{
		if(m_bDragging)
			CRTDraw::RTDrawBitmap(&memDC,&rtThumb,m_ScrollBarHorizontalBitmap[BMP_DOWN],m_ScrollBarHorizontalBitmapDrawMode[BMP_DOWN]);
		else
			CRTDraw::RTDrawBitmap(&memDC,&rtThumb,m_ScrollBarHorizontalBitmap[BMP_NORMAL],m_ScrollBarHorizontalBitmapDrawMode[BMP_NORMAL]);
	}
}

BOOL CRTScrollBar1::OnEraseBkgnd(CDC* pDC)
{
	if(!m_IsEnableRTStyle)
		return CScrollBar::OnEraseBkgnd(pDC);
	else
		return FALSE;
}

void CRTScrollBar1::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	CScrollBar::OnLButtonUp(nFlags, point);
}

void CRTScrollBar1::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	CScrollBar::OnLButtonDown(nFlags, point);
}

void CRTScrollBar1::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	CScrollBar::OnMouseMove(nFlags, point);
}

BOOL CRTScrollBar1::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ڴϢ/Ĭֵ

	return CScrollBar::OnMouseWheel(nFlags, zDelta, pt);
}

void CRTScrollBar1::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: ڴϢ
	// ΪͼϢ CScrollBar::OnPaint()
}

void CRTScrollBar1::EnableRTStyle(BOOL IsEnable)
{
	m_IsEnableRTStyle = IsEnable;
}

void CRTScrollBar1::SetHorizontalBitmap(CBitmap* pHorizontal[],UINT DrawMode[])
{
	for(int i = 0; i < 5; i ++)
	{
		m_ScrollBarHorizontalBitmap[i] = pHorizontal[i];
		m_ScrollBarHorizontalBitmapDrawMode[i] = DrawMode[i];
	}
}

void CRTScrollBar1::SetVerticalBitmap(CBitmap* pVertical[],UINT DrawMode[])
{
	for(int i = 0; i < 5; i ++)
	{
		m_ScrollBarVerticalBitmap[i] = pVertical[i];
		m_ScrollBarVerticalBitmapDrawMode[i] = DrawMode[i];
	}
}

void CRTScrollBar1::SetVerticalUpArrowBitmap(CBitmap* pVertical[],UINT DrawMode[])
{
	for(int i = 0; i < 5; i ++)
	{
		m_ScrollBarUpArrowBitmap[i] = pVertical[i];
		m_ScrollBarUpArrowBitmapDrawMode[i] = DrawMode[i];
	}
}

void CRTScrollBar1::SetVerticalDownArrowBitmap(CBitmap* pVertical[],UINT DrawMode[])
{
	for(int i = 0; i < 5; i ++)
	{
		m_ScrollBarDownArrowBitmap[i] = pVertical[i];
		m_ScrollBarDownArrowBitmapDrawMode[i] = DrawMode[i];
	}
}

void CRTScrollBar1::SetHorizontalLeftArrowBitmap(CBitmap* pHorizontal[],UINT DrawMode[])
{
	for(int i = 0; i < 5; i ++)
	{
		m_ScrollBarLeftArrowBitmap[i] = pHorizontal[i];
		m_ScrollBarLeftArrowBitmapDrawMode[i] = DrawMode[i];
	}
}

void CRTScrollBar1::SetHorizontalRightArrowBitmap(CBitmap* pHorizontal[],UINT DrawMode[])
{
	for(int i = 0; i < 5; i ++)
	{
		m_ScrollBarRightArrowBitmap[i] = pHorizontal[i];
		m_ScrollBarRightArrowBitmapDrawMode[i] = DrawMode[i];
	}
}

void CRTScrollBar1::SetSizeArea(ScrollBarSizeArea Area)
{
	m_SizeArea = Area;
}
